<?php
// social_data.php
// This script connects to a MySQL database, retrieves social media data,
// and returns the result in JSON format.

$host    = 'webdev.iyaserver.com';        
$db      = 'westongu_memecoin';   
$user    = 'westongu_guest';    
$pass    = 'acad274final';    
$charset = 'utf8mb4';

// Replace this with your table name
$table   = 'social_final_2';

// PDO connection settings
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
];

// Set output type to JSON
header('Content-Type: application/json; charset=utf-8');


try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "error"   => "Database connection failed",
        "details" => $e->getMessage()
    ]);
    exit;
}


// Optional filters: ?coin_id=DOGE&timestamp=1234567890&ts=2024-11-25 10:00:00
$where  = [];
$params = [];

// Filter by coin_id
if (!empty($_GET['coin_id'])) {
    $where[] = "coin_id = :coin_id";
    $params[':coin_id'] = $_GET['coin_id'];
}

// Filter by timestamp
if (!empty($_GET['timestamp']) && ctype_digit($_GET['timestamp'])) {
    $where[] = "timestamp = :timestamp";
    $params[':timestamp'] = intval($_GET['timestamp']);
}

// Filter by ts (datetime string)
if (!empty($_GET['ts'])) {
    $where[] = "ts = :ts";
    $params[':ts'] = $_GET['ts'];
}

// Optional limit parameter
$limit = "";
if (!empty($_GET['limit']) && ctype_digit($_GET['limit'])) {
    $limit = " LIMIT " . intval($_GET['limit']);
}

// Base SQL query
$sql = "
    SELECT 
        coin_id,
        timestamp,
        ts,
        market_cap,
        sentiment,
        low_price,
        social_dominance,
        high_price,
        posts_created,
        market_dominance,
        open_price,
        galaxy_score,
        spam,
        contributors_created,
        posts_active,
        volume_usd,
        interactions,
        contributors_active,
        alt_rank,
        close_price,
        circulating_supply
    FROM $table
";

// Add WHERE conditions if needed
if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

// Order by most recent timestamp first
$sql .= " ORDER BY timestamp DESC, coin_id ASC";
$sql .= $limit;


try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll();
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "error"   => "Query execution failed",
        "details" => $e->getMessage()
    ]);
    exit;
}


echo json_encode([
    "success" => true,
    "count"   => count($rows),
    "data"    => $rows
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK);

?>
